<?php
$db = new SQLite3('./api/database.db');
function initializeDatabase($db) {
	$tables = [
		"users" => "CREATE TABLE IF NOT EXISTS users(id INTEGER PRIMARY KEY,username TEXT ,password TEXT)",
		"dns" => "CREATE TABLE IF NOT EXISTS dns(id INTEGER PRIMARY KEY  AUTOINCREMENT  NOT NULL, title TEXT, url TEXT)",
		"vpn" => "CREATE TABLE IF NOT EXISTS vpn(id INTEGER PRIMARY KEY	AUTOINCREMENT  NOT NULL, vpn_country TEXT ,vpn_file_name TEXT, username TEXT, password TEXT, embed TEXT)",
		"extra_accounts" => "CREATE TABLE IF NOT EXISTS vpn(id INTEGER PRIMARY KEY	AUTOINCREMENT  NOT NULL, username TEXT, password TEXT, status TEXT, expiry TEXT)",

	];
	
	

	foreach ($tables as $tableName => $createStmt) {
		$db->exec($createStmt);
	}
	
	foreach ($insert as $tableName => $createStmt) {
		$rows = $db->query("SELECT COUNT(*) as count FROM ".$tableName);
		$row = $rows->fetchArray();
		$numRows = $row['count'];
		if ($numRows == 0){
			$db->exec($createStmt);
		}
	}
}

function sanitize($data) {
	$data = trim($data);
	$data = htmlspecialchars($data, ENT_QUOTES );
	$data = SQLite3::escapeString($data);
	return $data;
}